/*    Melissa Data Address Object for Windows/Linux/Solaris 
              Address Object C++ interface                     */
 
/*********************************************************************************
    If you should have any comments, suggestions or improvements to these samples, 
    we welcome you to contact us at SampleCode@melissadata.com. Also visit our 
    developer bulletin board at forum.melissadata.com.
*********************************************************************************/

#include <iostream>
#include <string.h>
#include "mdAddr.h"

using namespace std;

/********************* LICENSE STRINGS *************************
*  To unlock the full functionality of Address Object, please  *
*  call a sales representative at 1-800-MELISSA ext. 3         * 
*  (1-800-635-4772 x3) for a license string. Insert your valid *
*  license in place of "DEMO". Without a valid license         *                
*  string, AddressCheck will only verify Nevada addresses.     *
*                                                              *
* SetLicenseString also checks for a valid license in the      * 
* MDADDR_LICENSE environment variable. This allows you to      *
* modify the license without recompilation.                    *
****************************************************************/
#define dLICENSE "DEMO"

/*********************** DATA FILE PATH  ***********************
* File location path is set to the default Data File location. *
* Change this value if you installed the data files to a       *
* different folder.                                            *
* The Data Files Directory must contain the following files:   *
* mdAddr.dat, mdAddr.lic, mdAddr.nat, and mdAddr.str           *
***************************************************************/
#define dFILELOC "C:\\Program Files\\Melissa DATA\\DQT\\Data"


mdAddr ao;

const char bar[]="========================================================================\n";

void display();

int main(int argc,char **argv)
{
  int ec;
    
    // Setting License
  ao.SetLicenseString(dLICENSE);

  // Set path to standard Data Files and add-ons
  ao.SetPathToUSFiles(dFILELOC);

  //CASS required add-ons for highest level of validation. Should be used by non-demo users.
  //ao.SetPathToDPVDataFiles(dFILELOC);
  //ao.SetPathToSuiteLinkDataFiles(dFILELOC);
  //ao.SetPathToLACSLinkDataFiles(dFILELOC);

  //ao.SetPathToRBDIFiles(dFILELOC);              //Delivery Indicator Add-on (Residence or Business)
  //ao.SetPathToCanadaFiles(dFILELOC);            //Canadian Address Validation Add-on
  //ao.SetPathToSuiteFinderDataFiles(dFILELOC);   //AddressPlus Add-on (appends residential suites)

  cout << bar;
  cout << "     ADDRESS OBJECT C++ EXAMPLE  "  << endl;
  cout << "     Build Number: " << ao.GetBuildNumber() << endl;
  cout << "  Initialize Code: " << (ec = ao.InitializeDataFiles()) << endl;
  cout << "Initialize Status: " << ao.GetInitializeErrorString() << endl;
  cout << "    Database Date: " << ao.GetDatabaseDate() << endl;
  cout << "  Expiration Date: " << ao.GetExpirationDate() << endl;
  cout << bar;
  
  if (ec) return 0;

  char company[50],address[50],address2[50],lastline[50];
  char suite[20],city[30],state[5],zip[15],urbanization[30],lastname[25];
  char &ch = lastline[0];
  do {
    cout << "     Company: ";      cin.getline(company,sizeof company);
    cout << "     Address: ";      cin.getline(address,sizeof address);
    cout << "    Address2: ";     cin.getline(address2,sizeof address2);
    cout << "       Suite: ";        cin.getline(suite,sizeof suite);
    cout << "        City: ";         cin.getline(city,sizeof city);
    cout << "       State: ";        cin.getline(state,sizeof state);
    cout << "         Zip: ";          cin.getline(zip,sizeof zip);
    cout << "Urbanization: "; cin.getline(urbanization,sizeof urbanization);
    //Suite Finder Add-on
    //cout << "    LastName: ";     cin.getline(lastname,sizeof lastname);

    // clear any remaining properties from a previous call
    ao.ClearProperties();

    //set the input properties
    ao.SetCompany(company);
    ao.SetAddress(address);
    ao.SetAddress2(address2);
    ao.SetSuite(suite);
    ao.SetLastLine(lastline);
    ao.SetCity(city);
    ao.SetState(state);
    ao.SetZip(zip);
    ao.SetUrbanization(urbanization);
    //ao.SetLastName(lastname);

    ao.VerifyAddress();
    display();

    cout << "Press any key to continue, press X or ^D to exit\n";
    cin.getline(lastline,sizeof lastline);
  } while (cin.good() && (ch != 'x') && (ch != 'X'));
  return 0;
}

void display()
{
  const char* resultsString;
  cout << bar;
  
  // results are returned as a delimited string, so we parse here...
    resultsString = ao.GetResults();
        cout << "Results Codes..." << endl;
        if ((strstr(resultsString,"AS01")!=0) || (strstr(resultsString,"AS02")!=0) || (strstr(resultsString,"AS03")!=0))
        {    
          // address was verified
          if (strstr(resultsString,"AS01")!=0)
            cout <<" AS01: Full Address Matched to Postal Database and is deliverable "<<endl;
          if (strstr(resultsString,"AS02")!=0)
            cout <<" AS02: Address matched to USPS database but a suite was missing or invalid "<<endl;
		  if (strstr(resultsString,"AS03")!=0)
			cout <<" AS03: Valid Physical Address, not Serviced by the USPS "<<endl;
      } 
    
      //Display additional level of verification/comments
	  
      if (strstr(resultsString,"AS09")!=0)
            cout <<" AS09: Foreign Postal Code Detected  "<<endl;
        if (strstr(resultsString,"AS10")!=0)
            cout <<" AS10: Address Matched to CMRA "<<endl;
        if (strstr(resultsString,"AS20")!=0)
            cout <<" AS20: Address Deliverable by USPS only  "<<endl;
        if (strstr(resultsString,"AS13")!=0)
            cout <<" AS13: Address has been Updated by LACSLink  "<<endl;
        if (strstr(resultsString,"AS14")!=0)
            cout <<" AS14: Suite Appended by SuiteLink  "<<endl;
        if (strstr(resultsString,"AS15")!=0)
            cout <<" AS15: Suite Appended by SuiteFinder  "<<endl;
        if (strstr(resultsString,"AS16")!=0)
            cout <<" AS16: Address is vacant. "<<endl;
        if (strstr(resultsString,"AS17")!=0)
            cout <<" AS17: Alternate delivery. "<<endl;
        if (strstr(resultsString,"AS18")!=0)
            cout <<" AS18: DPV processing was terminated artificially created adresses detected. "<<endl;
        if (strstr(resultsString,"AS21")!=0)
            cout <<" AS21: Alternate Address Suggestion Found "<<endl;
        if (strstr(resultsString,"AS22")!=0)
            cout <<" AS22: No Alternate Address Suggestion Found"<<endl;
        if (strstr(resultsString,"AS23")!=0)
            cout <<" AS23: Extraneous information found "<<endl;      

      if (strstr(resultsString,"AE")!=0)
      {   
          // there was an error in verifying the address
          cout <<" Address Could not be verified...  "<<endl;
          if (strstr(resultsString,"AE01")!=0)
            cout <<" AE01: Zip Code Error  "<<endl;
          if (strstr(resultsString,"AE02")!=0)
            cout <<" AE02: Unknown Street Error  "<<endl;
          if (strstr(resultsString,"AE03")!=0)
            cout <<" AE03: Component Mismatch Error  "<<endl;
          if (strstr(resultsString,"AE04")!=0)
            cout <<" AE04: Non-Deliverable Address Error  "<<endl;
          if (strstr(resultsString,"AE05")!=0)
            cout <<" AE05: Multiple Match Error  "<<endl;
          if (strstr(resultsString,"AE06")!=0)
            cout <<" AE06: Early Warning System Error  "<<endl;
          if (strstr(resultsString,"AE07")!=0)
            cout <<" AE07: Missing Minimum Address Input  "<<endl;
          if (strstr(resultsString,"AE08")!=0)
            cout <<" AE08: Suite Range Invalid Error "<<endl;
          if (strstr(resultsString,"AE09")!=0)
            cout <<" AE09: Suite Range Missing Error  "<<endl;
          if (strstr(resultsString,"AE10")!=0)
            cout <<" AE10: Primary Range Invalid Error  "<<endl;
          if (strstr(resultsString,"AE11")!=0)
            cout <<" AE11: Primary Range Missing Error  "<<endl;
          if (strstr(resultsString,"AE12")!=0)
            cout <<" AE12: PO, HC, or RR Box Number Invalid  "<<endl;
          if (strstr(resultsString,"AE13")!=0)
            cout <<" AE13: PO, HC, or RR Box Number Missing  "<<endl;
          if (strstr(resultsString,"AE14")!=0)
            cout <<" AE14: CMRA Secondary Missing Error "<<endl;

          // program can not attempt address lookup
          if (strstr(resultsString,"AE15")!=0)
            cout <<" AE15: Demo Mode limitation "<<endl;
          if (strstr(resultsString,"AE16")!=0)
            cout <<" AE16: Expired Database, Please Update "<<endl;
            
          if (strstr(resultsString,"AE17")!=0)
            cout <<" AE17: Unnecessary Suite Error "<<endl;
          if (strstr(resultsString,"AE19")!=0)
            cout <<" AE19: Max time for FindSuggestion exceeded"<<endl;       
          if (strstr(resultsString,"AE20")!=0)
            cout <<" AE20: FindSuggestion cannot be used"<<endl;           
      } 
      
      // a change was made to the input data  
      if (strstr(resultsString,"AC01")!=0)
        cout <<" AC01: ZIP Code Change"<<endl; 
      if (strstr(resultsString,"AC02")!=0)	
        cout <<" AC02: State Change"<<endl; 
	    if (strstr(resultsString,"AC03")!=0)
        cout <<" AC03: City Change"<<endl; 
	    if (strstr(resultsString,"AC04")!=0)
        cout <<" AC04: Base/Alternate Change"<<endl; 
	    if (strstr(resultsString,"AC05")!=0)
        cout <<" AC05: Alias Name Change"<<endl; 
    	if (strstr(resultsString,"AC06")!=0)
        cout <<" AC06: Address1/Address2 Swap"<<endl; 
	    if (strstr(resultsString,"AC07")!=0)
        cout <<" AC07: Address1/Company Swap"<<endl; 
    	if (strstr(resultsString,"AC08")!=0)
        cout <<" AC08: Plus4 Change"<<endl; 
	    if (strstr(resultsString,"AC09")!=0)
        cout <<" AC09: Urbanization Change"<<endl; 
    	if (strstr(resultsString,"AC10")!=0)
        cout <<" AC10: Street Name Change"<<endl; 
    	if (strstr(resultsString,"AC11")!=0)
        cout <<" AC11: Street Suffix Change"<<endl;
      if (strstr(resultsString,"AC12")!=0)
        cout <<" AC12: Street Directional Change"<<endl; 
    	if (strstr(resultsString,"AC13")!=0)
        cout <<" AC13: Suite Name Change"<<endl;

    // output properties
        cout<<endl;
        cout<<" Carrier Route:           "<<ao.GetCarrierRoute()<<endl;
      cout<<" Delivery Point Code:     "<<ao.GetDeliveryPointCode()<<endl;
      cout<<" DeliveryPointCheckDigit: "<<ao.GetDeliveryPointCheckDigit()<<endl;
      cout<<" DPV Footnotes:           "<<ao.GetDPVFootnotes()<<endl;
      cout<<endl;
      cout<<" Address Type Code:      "<<ao.GetAddressTypeCode()<<endl;
      cout<<" Address Type Address:   "<<ao.GetAddressTypeString()<<endl;
      cout<<" City Abbreviation:      "<<ao.GetCityAbbreviation()<<endl;
        cout<<" County Name:            "<<ao.GetCountyName()<<endl;
        cout<<" County FIPS:            "<<ao.GetCountyFips()<<endl;
      cout<<" Country Code:           "<<ao.GetCountryCode()<<endl;
      cout<<" Congressional District: "<<ao.GetCongressionalDistrict()<<endl;
      cout<<" Time Zone:              "<<ao.GetTimeZone()<<endl;
      cout<<" Time Zone Code:         "<<ao.GetTimeZoneCode()<<endl;
      cout<<" Urbanization:           "<<ao.GetUrbanization()<<endl;
        cout<<" ZipType:                "<<ao.GetZipType()<<endl;
        cout<<endl;
      cout<<"Parsed Output Address..."<<endl;
      cout<<" Suite Name:             "<<ao.GetParsedSuiteName()<<endl;
      cout<<" Suite Range:            "<<ao.GetParsedSuiteRange()<<endl;
      cout<<" Address Range:          "<<ao.GetParsedAddressRange()<<endl;
      cout<<" Address PreDirection:   "<<ao.GetParsedPreDirection()<<endl;
      cout<<" Street Name:            "<<ao.GetParsedStreetName()<<endl;
      cout<<" Suffix:                 "<<ao.GetParsedSuffix()<<endl;
      cout<<" Post Direction:         "<<ao.GetParsedPostDirection()<<endl;
      cout<<" Private MailBox Name:   "<<ao.GetParsedPrivateMailboxName()<<endl;
      cout<<" Private MailBox Number: "<<ao.GetParsedPrivateMailboxNumber()<<endl;
      cout<<" Garbage:                "<<ao.GetParsedGarbage()<<endl;
        cout<<endl;
      cout<<" MSA:                    "<<ao.GetMsa()<<endl;
      cout<<" PMSA:                   "<<ao.GetPmsa()<<endl;
      cout<<" CMRA:                   "<<ao.GetCMRA()<<endl;
      cout<<" Private Mail Box:       "<<ao.GetPrivateMailbox()<<endl;
      cout<<endl; 
      cout<<" ELot Order:             "<<ao.GetELotOrder()<<endl;
      cout<<" ELot Number:            "<<ao.GetELotNumber()<<endl;
      cout<<" LACS:                   "<<ao.GetLACS()<<endl;
      cout<<" LACS Link Indicator:    "<<ao.GetLACSLinkIndicator()<<endl;
      cout<<" LACS Link Return Code:  "<<ao.GetLACSLinkReturnCode()<<endl;
      cout<<" EWS Flag:               "<<ao.GetEWSFlag()<<endl;
      cout<<" RBDI:                   "<<ao.GetRBDI()<<endl;
        cout<<" SuiteLink Return Code:  "<<ao.GetSuiteLinkReturnCode()<<endl;
    
  
  cout << bar;
}  //end function display
